#include "headers.h"
#include "syscall.h"

long signal(int sig, void (*handler)(int))
{
	return SYSCALL2(48, sig, handler);
}

long alarm(int seconds)
{
	return SYSCALL1(27, seconds);
}

long sleep(unsigned long seconds)
{
	struct timespec t, r;

	t.tv_sec = seconds;
	t.tv_nsec = 0;

	nanosleep(&t, &r);

	return r.tv_sec;
}

long nanosleep(struct timespec *rqtp, struct timespec *rmtp)
{
	return SYSCALL2(162, rqtp, rmtp);
}
